var root = "http://"+document.location.hostname+"/poisson-area/";
var valor = 320.00;
function iniciarSessao(){
	$.ajax({
		url: root+"/pagamento/pagseguro.php",
		type: 'POST',
		dataType: 'json',
		success: function(data){
			PagSeguroDirectPayment.setSessionId(data.id);
    },
    complete: function(){
      listaMeiosPagamento();
      mostrarBandeira();
    }

	})
}

function listaMeiosPagamento(){
  PagSeguroDirectPayment.getPaymentMethods({
    amount: valor,
    success: function(data) {
        $.each(data.paymentMethods.CREDIT_CARD.options, function(i, obj){
          $('.cred').append("<div><img src=https://stc.pagseguro.uol.com.br"+obj.images.SMALL.path+">"+obj.name+"</div>");
        });
        $('.boleto').append("<div><img src=https://stc.pagseguro.uol.com.br"+data.paymentMethods.BOLETO.options.BOLETO.images.SMALL.path+">"+data.paymentMethods.BOLETO.name+"</div>");
        $.each(data.paymentMethods.ONLINE_DEBIT.options, function(i, obj){
          $('.debito').append("<div><img src=https://stc.pagseguro.uol.com.br"+obj.images.SMALL.path+">"+obj.name+"</div>");
        });
    },
    
    complete: function(data) {
        getTolkenCard();
    }
  });
}
function mostrarBandeira(){
  $('#nmrCartao').on('keyup', function(){
    var nmrCard = $(this).val();
    var qtd = nmrCard.length;

    if(qtd == 6){
      PagSeguroDirectPayment.getBrand({
        cardBin: nmrCard,
        success: function(response) {
          var flag = response.brand.name;
          $('#flag').html('<img src=https://stc.pagseguro.uol.com.br/public/img/payment-methods-flags/42x20/'+flag+'.png>');
        },
        error: function(response) {
          alert('Cartão não reconhecido');
          $('#flag').empty();
        }
      });
    }    
  });
}

function getTolkenCard() {
	PagSeguroDirectPayment.createCardToken({
		cardNumber: '4111111111111111', // Número do cartão de crédito
		brand: 'visa', // Bandeira do cartão
		cvv: '123', // CVV do cartão
		expirationMonth: '12', // Mês da expiração do cartão
		expirationYear: '2030', // Ano da expiração do cartão, é necessário os 4 dígitos.
		success: function(response) {
				 $('#tolkenCard').val(response.card.tolken)
		}
	});
}


iniciarSessao();